/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpManager;

import ibm.nways.analysis.dpCommon.GraphDefinition;
import ibm.nways.analysis.dpCommon.GraphPollingObjectDefinition;
import ibm.nways.analysis.dpCommon.NodeDefinition;
import ibm.nways.analysis.dpCommon.NotifyObject;
import ibm.nways.analysis.dpCommon.PollingObjectDefinition;
import ibm.nways.analysis.dpCommon.ResourceDefinition;
import ibm.nways.analysis.dpCommon.ViewDefinition;
import ibm.nways.analysis.dpManager.DpmClientApplet;
import ibm.nways.ras.Traces;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public class InitialConfig {
    private DpmClientApplet server;
    private static final int POLLING_OBJECTS = 1;
    private static final int RESOURCES = 2;
    private static final int NODES = 3;
    private static final int VIEWS = 4;
    private static final int TEMPLATES = 5;
    private static final int LAST_CONFIG = 5;

    public InitialConfig(DpmClientApplet dpmClientApplet) {
        this(dpmClientApplet, "");
    }

    public InitialConfig(DpmClientApplet dpmClientApplet, String string) {
        int n = 0;
        this.server = dpmClientApplet;
        n = 1;
        while (n <= 5) {
            this.loadConfigFile(n, string);
            ++n;
        }
    }

    private void loadConfigFile(int n, String string) {
        try {
            switch (n) {
                case 1: {
                    this.processPollingObjectDefinitions(String.valueOf(string) + "pollobj.def");
                    return;
                }
                case 2: {
                    this.processResourceDefinitions(String.valueOf(string) + "resource.def");
                    return;
                }
                case 3: {
                    this.processNodeDefinitions(String.valueOf(string) + "node.def");
                    return;
                }
                case 5: {
                    this.processTemplateDefinitions(String.valueOf(string) + "template.def");
                    return;
                }
                case 4: {
                    this.processViewDefinitions(String.valueOf(string) + "view.def");
                    return;
                }
                default: {
                    return;
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return;
        }
    }

    private char getLineType(String string) {
        return string.charAt(0);
    }

    private String getLineInfo(String string) {
        String string2 = string.substring(2);
        return string2.trim();
    }

    private void processPollingObjectDefinitions(String string) throws FileNotFoundException {
        PollingObjectDefinition pollingObjectDefinition = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        float f = 0.0f;
        float f2 = 0.0f;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        NotifyObject notifyObject = null;
        char c = '\u0000';
        String string7 = null;
        boolean bl = true;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        String string8 = new String();
        try {
            while ((string8 = bufferedReader.readLine()) != null && string8.length() > 0) {
                c = this.getLineType(string8);
                string7 = this.getLineInfo(string8);
                switch (c) {
                    case 'P': {
                        if (!bl) {
                            notifyObject = n3 == 4 ? new NotifyObject(string5, f, string6, f2, n) : new NotifyObject(n3, n);
                            pollingObjectDefinition = new PollingObjectDefinition(string3, n2, string2, string4, notifyObject);
                            this.server.addPollingObjectDefinition(pollingObjectDefinition);
                        }
                        string3 = new String(string7);
                        bl = false;
                        break;
                    }
                    case 'E': {
                        string2 = new String(string7);
                        break;
                    }
                    case 'I': {
                        n = Integer.valueOf(string7);
                        break;
                    }
                    case 'D': {
                        n2 = Integer.valueOf(string7);
                        break;
                    }
                    case 'U': {
                        string4 = new String(string7);
                        break;
                    }
                    case 'N': {
                        n3 = Integer.valueOf(string7);
                        break;
                    }
                    case 'A': {
                        string5 = new String(string7);
                        break;
                    }
                    case 'H': {
                        f = Float.valueOf(string7).floatValue();
                        break;
                    }
                    case 'R': {
                        string6 = new String(string7);
                        break;
                    }
                    case 'L': {
                        f2 = Float.valueOf(string7).floatValue();
                        break;
                    }
                }
            }
            if (!bl) {
                notifyObject = n3 == 4 ? new NotifyObject(string5, f, string6, f2, n) : new NotifyObject(n3, n);
                pollingObjectDefinition = new PollingObjectDefinition(string3, n2, string2, string4, notifyObject);
                this.server.addPollingObjectDefinition(pollingObjectDefinition);
            }
            bufferedReader.close();
            return;
        }
        catch (IOException iOException) {
            System.out.println("Parse error, last line processed : " + string8);
            iOException.printStackTrace();
            return;
        }
    }

    private void processResourceDefinitions(String string) throws FileNotFoundException {
        ResourceDefinition resourceDefinition = null;
        char c = '\u0000';
        String string2 = null;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        String string3 = new String();
        try {
            while ((string3 = bufferedReader.readLine()) != null && string3.length() > 0) {
                c = this.getLineType(string3);
                string2 = this.getLineInfo(string3);
                switch (c) {
                    case 'R': {
                        resourceDefinition = new ResourceDefinition(string2, null, null);
                        this.server.addResourceDefinition(resourceDefinition);
                        break;
                    }
                }
            }
            bufferedReader.close();
            return;
        }
        catch (IOException iOException) {
            System.out.println("Parse error, last line processed : " + string3);
            iOException.printStackTrace();
            return;
        }
    }

    private void processNodeDefinitions(String string) throws FileNotFoundException {
        NodeDefinition nodeDefinition = null;
        char c = '\u0000';
        String string2 = null;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        String string3 = new String();
        try {
            while ((string3 = bufferedReader.readLine()) != null && string3.length() > 0) {
                c = this.getLineType(string3);
                string2 = this.getLineInfo(string3);
                switch (c) {
                    case 'N': {
                        nodeDefinition = new NodeDefinition(string2);
                        this.server.addNodeDefinition(nodeDefinition);
                        break;
                    }
                }
            }
            bufferedReader.close();
            return;
        }
        catch (IOException iOException) {
            System.out.println("Parse error, last line processed : " + string3);
            iOException.printStackTrace();
            return;
        }
    }

    private void processTemplateDefinitions(String string) throws FileNotFoundException {
        String string2 = null;
        String string3 = null;
        Vector<String> vector = null;
        Vector<String> vector2 = null;
        char c = '\u0000';
        String string4 = null;
        boolean bl = true;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        String string5 = new String();
        try {
            while ((string5 = bufferedReader.readLine()) != null && string5.length() > 0) {
                c = this.getLineType(string5);
                string4 = this.getLineInfo(string5);
                switch (c) {
                    case 'N': {
                        if (!bl) {
                            this.server.addTemplateDefinitionsToResource(vector, vector2, string2, string3);
                        }
                        vector = new Vector<String>();
                        vector2 = new Vector<String>();
                        string2 = new String(string4);
                        bl = false;
                        break;
                    }
                    case 'R': {
                        string3 = new String(string4);
                        break;
                    }
                    case 'P': {
                        vector.addElement(string4);
                        break;
                    }
                    case 'V': {
                        vector2.addElement(string4);
                        break;
                    }
                }
            }
            if (!bl) {
                this.server.addTemplateDefinitionsToResource(vector, vector2, string2, string3);
            }
            bufferedReader.close();
            return;
        }
        catch (IOException iOException) {
            System.out.println("Parse error, last line processed : " + string5);
            iOException.printStackTrace();
            return;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processViewDefinitions(String var1_1) throws FileNotFoundException {
        var2_2 = '\u0000';
        var3_3 = null;
        var4_4 = true;
        var5_5 = null;
        var6_6 = null;
        var7_7 = null;
        var8_8 = false;
        var9_9 = new BufferedReader(new FileReader(var1_1));
        var10_10 = new String();
        try {
            block16: while (true) lbl-1000:
            // 13 sources

            {
                if ((var10_10 = var9_9.readLine()) == null || var10_10.length() <= 0) {
                    if (!var4_4) {
                        if (var7_7 != null) {
                            var6_6.addPollingObject(var7_7);
                        }
                        if (var6_6 != null) {
                            var5_5.addGraph(var6_6);
                        }
                        if (var5_5 != null) {
                            this.server.addViewDefinition(var5_5);
                        }
                    }
                    var9_9.close();
                    return;
                }
                var2_2 = this.getLineType(var10_10);
                var3_3 = this.getLineInfo(var10_10);
                switch (var2_2) {
                    case 'V': {
                        if (!var4_4) {
                            if (var7_7 != null) {
                                var6_6.addPollingObject(var7_7);
                                var7_7 = null;
                            }
                            if (var6_6 != null) {
                                var5_5.addGraph(var6_6);
                                var6_6 = null;
                            }
                            if (var5_5 != null) {
                                this.server.addViewDefinition(var5_5);
                            }
                        }
                        var5_5 = new ViewDefinition(var3_3);
                        var4_4 = false;
                        ** break;
                    }
                    case 'G': {
                        if (var7_7 != null) {
                            var6_6.addPollingObject(var7_7);
                            var7_7 = null;
                        }
                        if (var6_6 != null) {
                            var5_5.addGraph(var6_6);
                            var6_6 = null;
                        }
                        var6_6 = new GraphDefinition(var3_3);
                        ** break;
                    }
                    case 'T': {
                        var11_11 = Integer.valueOf(var3_3);
                        var6_6.setGraphType(var11_11);
                        ** break;
                    }
                    case 'R': {
                        var12_13 = new String(var3_3);
                        var13_14 = null;
                        var14_15 = null;
                        var15_16 = var12_13.indexOf(45);
                        if (var15_16 != -1) {
                            if (var15_16 > 0) {
                                var13_14 = var12_13.substring(0, var15_16);
                            }
                            var14_15 = var12_13.substring(var15_16 + 1);
                        } else if (var12_13.length() > 0) {
                            var13_14 = var12_13;
                        }
                        if (var13_14 != null && (var15_16 = var13_14.indexOf(44)) != -1) {
                            try {
                                var16_17 = Integer.valueOf(var13_14.substring(0, var15_16));
                                var17_21 = Integer.valueOf(var13_14.substring(var15_16 + 1));
                                var5_5.setPeriodEnding(var16_17, var17_21);
                            }
                            catch (NumberFormatException var16_18) {
                                Traces.logException(var16_18);
                            }
                        }
                        if (var14_15 == null || (var15_16 = var14_15.indexOf(44)) == -1) continue block16;
                        try {
                            var16_17 = Integer.valueOf(var14_15.substring(0, var15_16));
                            var17_21 = Integer.valueOf(var14_15.substring(var15_16 + 1));
                            var6_6.setPeriodEnding(var16_17, var17_21);
                        }
                        catch (NumberFormatException var16_19) {
                            Traces.logException(var16_19);
                        }
                        continue block16;
                    }
                    case 'U': {
                        var6_6.setUnits(var3_3);
                        ** break;
                    }
                    case 'P': {
                        if (var7_7 != null) {
                            var6_6.addPollingObject(var7_7);
                            var7_7 = null;
                        }
                        var7_7 = new GraphPollingObjectDefinition(var3_3);
                        ** break;
                    }
                    case 'N': {
                        if (var3_3.equals("ALL")) {
                            var7_7.setForAllNodes(true);
                            var8_8 = true;
                            ** break;
                        }
                        if (!var8_8) {
                            var7_7.setForAllNodes(false);
                        }
                        var7_7.addNodeKeyword(var3_3);
                        ** break;
                    }
                    case 'I': {
                        var16_20 = var3_3.indexOf(61);
                        var17_22 = var3_3.substring(0, var16_20).trim();
                        var18_23 = var3_3.substring(var16_20 + 1).trim();
                        var7_7.addInstanceData(var17_22, var18_23);
                        ** break;
                    }
                }
            }
        }
        catch (IOException var11_12) {
            System.out.println("Parse error, last line processed : " + var10_10);
            var11_12.printStackTrace();
            return;
        }
    }
}

